//OHSAT GAMES TUTORIAL: MEGALAGA 4 BONUS: Enemy Movement & Input
//There's a reference to Rolling in the OHSAT Tutorial for this lesson.
//It is your duty to make the reference to Weird Al and not Fred Durst or something equally terrible.   

//https://www.ohsat.com/tutorial/#mega-drive-tutorials 

#include <genesis.h>
#include <resources.h>

// Constants
#define LEFT_EDGE 0
#define RIGHT_EDGE 320

#define MAX_ENEMIES 6

#define ANIM_STRAIGHT 0
#define ANIM_MOVE 1
#define ANIM_DIE 7

// Struct Definition
typedef struct {
	int x;
	int y;
	int w;
	int h;
	int velx;
	int vely;
	int health;
	Sprite* sprite;
	char name[8];
} Entity;

// Globals
int offset = 0;
u16 enemiesLeft = 0;

Entity player = {0, 0, 16, 16, 0, 0, 0, NULL, "PLAYER"};
Entity player_2 = {0, 0, 16, 16, 0, 0, 0, NULL, "PLAYER2"};
Entity enemies_top[MAX_ENEMIES];
Entity enemies_bottom[MAX_ENEMIES];

// Function Declarations
void killEntity(Entity* e);
void reviveEntity(Entity* e);
void positionEnemies();
void positionPlayer();
void myJoyHandler(u16 joy, u16 changed, u16 state);

int main()
{
    JOY_init();
    JOY_setEventHandler(&myJoyHandler);

    SYS_disableInts();
    VDP_loadTileSet(background.tileset, 1, DMA);
    PAL_setPalette(PAL1, background.palette->data, DMA);
    PAL_setPalette(PAL2, background.palette->data, DMA);
    VDP_setScrollingMode(HSCROLL_PLANE, VSCROLL_PLANE);
    PAL_setColor(34,RGB24_TO_VDPCOLOR(0x0078f8));
    SYS_enableInts();

    SPR_init();

    // Initialize players
    player.x = 152; player.y = 192; player.health = 1;
    player.sprite = SPR_addSprite(&ship, player.x, player.y, TILE_ATTR(PAL1, 0, FALSE, FALSE));

    player_2.x = 100; player_2.y = 192; player_2.health = 1;
    player_2.sprite = SPR_addSprite(&ship1, player_2.x, player_2.y, TILE_ATTR(PAL1, 0, FALSE, FALSE));

    // Fill background
    for (int i = 0; i < 1280; i++) {
        int thex = i % 40;
        int they = i / 40;
        int val = (random() % 10) + 1;
        if(val > 3) val = 1;
        VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, 0, 0, val), thex, they);
    }

    // Create first wave of enemies (top row)
    for(int i = 0; i < MAX_ENEMIES; i++) {
        Entity* e = &enemies_top[i];
        e->x = i * 32;
        e->y = 32;
        e->w = 16;
        e->h = 16;
        e->velx = 1;
        e->health = 1;
        e->sprite = SPR_addSprite(&ship, e->x, e->y, TILE_ATTR(PAL2, 0, TRUE, FALSE));
        sprintf(e->name, "En%d", i);
        enemiesLeft++;
    }

    // Create second wave of enemies (bottom row, moving left)
    for(int i = 0; i < MAX_ENEMIES; i++) {
        Entity* e = &enemies_bottom[i];
        e->x = 320 - (i * 32);
        e->y = 64;
        e->w = 16;
        e->h = 16;
        e->velx = -1;
        e->health = 1;
        e->sprite = SPR_addSprite(&nemo_sprite, e->x, e->y, TILE_ATTR(PAL2, 0, TRUE, FALSE));
        SPR_setAnim(e->sprite, ANIM_DIE);
        sprintf(e->name, "Nm%d", i);
        enemiesLeft++;
    }

    // Game loop
    while (1)
    {
        VDP_setVerticalScroll(BG_B, offset -= 2);
        if (offset <= -256) offset = 0;

        positionPlayer();
        positionEnemies();
        SPR_update();
        SYS_doVBlankProcess();
    }

    return 0;
}

// Handle controller input for two players
void myJoyHandler(u16 joy, u16 changed, u16 state)
{
    Entity* p = (joy == JOY_1) ? &player : &player_2;

    if (state & BUTTON_RIGHT) {
        p->velx = 2;
        SPR_setAnim(p->sprite, ANIM_MOVE);
        SPR_setHFlip(p->sprite, TRUE);
    } else if (state & BUTTON_LEFT) {
        p->velx = -2;
        SPR_setAnim(p->sprite, ANIM_MOVE);
        SPR_setHFlip(p->sprite, FALSE);
    } else {
        if ((changed & BUTTON_LEFT) || (changed & BUTTON_RIGHT)) {
            p->velx = 0;
            SPR_setAnim(p->sprite, ANIM_STRAIGHT);
        }
    }
}

// Apply velocity to player sprites and keep them on screen
void positionPlayer()
{
    // Player 1
    player.x += player.velx;
    if(player.x < LEFT_EDGE) player.x = LEFT_EDGE;
    if(player.x + player.w > RIGHT_EDGE) player.x = RIGHT_EDGE - player.w;
    SPR_setPosition(player.sprite, player.x, player.y);

    // Player 2
    player_2.x += player_2.velx;
    if(player_2.x < LEFT_EDGE) player_2.x = LEFT_EDGE;
    if(player_2.x + player_2.w > RIGHT_EDGE) player_2.x = RIGHT_EDGE - player_2.w;
    SPR_setPosition(player_2.sprite, player_2.x, player_2.y);
}

// Move enemy sprites left/right and bounce at screen edges
void positionEnemies()
{
    for(int i = 0; i < MAX_ENEMIES; i++) {
        Entity* e1 = &enemies_top[i];
        if(e1->health > 0) {
            e1->x += e1->velx;
            if(e1->x < LEFT_EDGE || (e1->x + e1->w) > RIGHT_EDGE)
                e1->velx = -e1->velx;
            SPR_setPosition(e1->sprite, e1->x, e1->y);
        }

        Entity* e2 = &enemies_bottom[i];
        if(e2->health > 0) {
            e2->x += e2->velx;
            if(e2->x < LEFT_EDGE || (e2->x + e2->w) > RIGHT_EDGE)
                e2->velx = -e2->velx;
            SPR_setPosition(e2->sprite, e2->x, e2->y);
        }
    }
}

void killEntity(Entity* e){
	e->health = 0;
	SPR_setVisibility(e->sprite, HIDDEN);
}

void reviveEntity(Entity* e){
	e->health = 1;
	SPR_setVisibility(e->sprite, VISIBLE);
}


/////////////////CHANGE LOG//////////////////

/*

//Summary of changes between MEGALAGA TUTORIAL 4 and BONUS TUTORIAL 3

1. Added Controller Input and Player Movement (from Lesson 4)
Controller system (JOY_init, JOY_setEventHandler) reintroduced to support user input.

Added myJoyHandler() to manage directional movement for:

Player 1 (JOY_1)

Player 2 (JOY_2)

Movement updates apply velocity (velx) and animations (ANIM_MOVE, ANIM_STRAIGHT) based on button presses.

2. Two-Player Support
Second player entity (player_2) fully integrated with:

Independent sprite

Independent movement logic

Input from a second controller

3. Enemy Management Expanded
Separated enemy groups:

enemies_top[]: Original row of enemies (left to right)

enemies_bottom[]: New second row (right to left, using nemo_sprite)

Both enemy rows move and bounce off screen edges independently.

Previous bug (overwriting enemies in the same array) was fixed by using two separate arrays.

4. Background & Sprite System Preserved
Vertical background scrolling from MEGALAGA 4 retained.

Tile background populated with randomized stars.

Sprites and palette setup maintained from original lessons.

5. Modularized Movement Logic
positionPlayer() handles both players' movement, screen bounds, and sprite placement.

positionEnemies() processes both top and bottom enemy arrays with bounce logic. 

*/

////////////////////NOTES////////////////////

/*

//Detailed Code Explanation (cute icons included)

🧱 1. Includes & Definitions

#include <genesis.h>
#include <resources.h>
These import SGDK functions and your compiled resources (sprites, tilesets, palettes).

🧩 Structs and Constants

#define LEFT_EDGE 0
#define RIGHT_EDGE 320
#define MAX_ENEMIES 6
#define ANIM_STRAIGHT 0
#define ANIM_MOVE 1
#define ANIM_DIE 7
These set screen boundaries and animation states.


typedef struct {
    int x, y, w, h;
    int velx, vely;
    int health;
    Sprite* sprite;
    char name[8];
} Entity;

Entity represents any object that moves and animates on screen, such as:

Players (player, player_2)

Enemies (enemies_top[], enemies_bottom[])

🧍 2. Global Variables

int offset = 0;  // Background scroll offset
u16 enemiesLeft = 0;

Entity player = {...}
Entity player_2 = {...}
Entity enemies_top[MAX_ENEMIES];
Entity enemies_bottom[MAX_ENEMIES];
We track two player entities and two waves of enemy entities (top and bottom).

🚀 3. Main Function

This is where the game starts and runs.

🔌 Input System

JOY_init();
JOY_setEventHandler(&myJoyHandler);
Initializes controller input and registers a callback function to handle input events.

🎨 Graphics Initialization

VDP_loadTileSet(...);         // Loads tiles for background
PAL_setPalette(...);          // Sets color palette
VDP_setScrollingMode(...);    // Enables background scrolling

👾 Sprite Engine

SPR_init();                   // Initializes sprite engine

👨‍🚀 Player Setup

player.sprite = SPR_addSprite(&ship, ...);
player_2.sprite = SPR_addSprite(&ship1, ...);
Each player gets their own sprite and position.

🌌 Background Star Field

for (int i = 0; i < 1280; i++) {
    int thex = i % 40;
    int they = i / 40;
    int val = (random() % 10) + 1;
    if(val > 3) val = 1;
    VDP_setTileMapXY(...);
}

Generates a randomized starry background using tilemap indexing.

👾 Enemy Creation

// Top enemies (left to right)
for (i = 0; i < MAX_ENEMIES; i++) {
    enemies_top[i] = {...};
    SPR_addSprite(&ship, ...);
}

// Bottom enemies (right to left)
for (i = 0; i < MAX_ENEMIES; i++) {
    enemies_bottom[i] = {...};
    SPR_addSprite(&nemo_sprite, ...);
    SPR_setAnim(..., ANIM_DIE);
}

Creates two separate waves of enemies using different sprites and directions.

🔁 Game Loop

while (1)
{
    VDP_setVerticalScroll(BG_B, offset -= 2);  // Scroll background
    if (offset <= -256) offset = 0;

    positionPlayer();     // Move and render players
    positionEnemies();    // Move and render enemies
    SPR_update();         // Apply all sprite changes
    SYS_doVBlankProcess(); // Wait for screen refresh
}

This infinite loop:

Scrolls the background

Moves enemies and players

Updates the sprite system

Synchronizes with the display's refresh

🎮 4. Input Handler

void myJoyHandler(u16 joy, u16 changed, u16 state)
Called whenever controller input changes. It:

Detects which controller (JOY_1 = player, JOY_2 = player_2)

Updates player movement direction (velx)

Changes animation state (ANIM_MOVE or ANIM_STRAIGHT)

Applies horizontal flip to the sprite (SPR_setHFlip)

🧍‍♂️ 5. positionPlayer()

void positionPlayer()
Moves both players:

Adds velocity to their x position

Keeps them within screen bounds

Updates the sprite's screen position

👾 6. positionEnemies()

void positionEnemies()
Handles both waves of enemies:

Adds velx to move them left or right

Bounces them when hitting screen edges

Calls SPR_setPosition() for rendering

💀 7. killEntity() / reviveEntity()

void killEntity(Entity* e) {
    e->health = 0;
    SPR_setVisibility(e->sprite, HIDDEN);
}

void reviveEntity(Entity* e) {
    e->health = 1;
    SPR_setVisibility(e->sprite, VISIBLE);
}

Utility functions for enabling/disabling entities based on game events (like damage, later collisions, etc.).

*/

/////////EXPERIMENTATION IDEAS///////////////

/*

We're touching tips between MEGALAGA BONUS TUTORIAL 3 and MEGALAGA 4 TUTORIAL
to see what game baby, be it GameBoy or GameGirl, we can make. 

*/

///////////ERROR HANDLING////////////////////
/*

*/